local sceneEnvironment = require('demosceneEnvironment')
scene = {} --     

function generateFlightTrajectory(model, speed, targetOffset)
	sceneAPI:addFlightController(model)
	sceneAPI:setUpdateFunc('mainThemeSceneUpdate')
	local ctrl = model.controller
	ctrl:setSpeed(speed) -- /
	ctrl:setTargetOffset(targetOffset) --    ,    	
	local ang=0
	local radius=0
	for i=0, 9, 1 do
		ang = (i/10)*6.2832 --2pi
		radius = 23000*(1+math.random(-40, 40)/100)
		ctrl:addKnot(math.sin(ang)*radius, 1500 + math.random(-1000, 1000), math.cos(ang)*radius);
	end
	local x,y,z = ctrl:getKnot(0)
	ctrl:addKnot(x,y,z);
end

function loadScene(scenePtr)
	sceneAPI = sceneEnvironment.getInterface(scenePtr)
	
	-- sceneAPI:setCloudsLowHigh(0, 2000)
	sceneAPI:setCloudsDensity(0)
	sceneAPI:setCirrus(false)	
	sceneAPI:setLensEffects(false)
	
	scene.cam = sceneAPI:addCamera(0, 0, 0)	
	scene.cam:setFarClip(100)
		
	-- -- F-15
	scene.f15 = sceneAPI:addModel("f-15", 0, 0, 0)
	scene.f15.transform:scale(250,250,250)
	generateFlightTrajectory(scene.f15, 7500, 800)
	scene.cam:attachTo(scene.f15, "Pylon1")
	--external
	scene.cam.transform:move(-5,1,-2);	
	scene.cam.transform:setOrient(-90,0,0);
	
end


function mainThemeSceneUpdate(t, dt)
end



